<?php
use Illuminate\Support\Facades\Artisan;
use App\Lib\Env;
use Modules\MenuBuilder\Http\Models\MenuItems;
use Modules\OpenAI\Entities\Archive;
function beforeUpgrade(){

    if (version_compare(\Modules\Addons\Entities\Addon::find('Upgrader')->get('version'), '1.7', '<')) {
        $sourcePath = storage_path('updates/Upgrader.zip');
        $destinationPath = base_path('Modules');
        $zip = new ZipArchive;
        if (File::exists($sourcePath) && $zip->open($sourcePath) === TRUE) {
            $zip->extractTo($destinationPath);
        }
        Artisan::call('optimize:clear');
        echo '<p>' . __('You will be redirect to the system. If not, click :x', ['x' => "<a href='" . route('systemUpdate.upgrade', ['waiting' => true]) . "'>" . __('here') . '</a>']) . "</p><meta http-equiv=\"refresh\" content=\"5;URL='" . route('systemUpdate.upgrade', ['waiting' => true]) . "'\" />";
        exit;
    }

    if (Env::get('APP_ENV') != 'local' || Env::get('APP_ENV') == '') {
        Env::set('APP_ENV', 'local');
        Artisan::call('cache:clear');
        Artisan::call('config:cache');
        Artisan::call('config:clear');
        Artisan::call('optimize:clear');
        echo '<p>' . __('Changing the environment. You will be redirect to the system. If not, click :x', ['x' => "<a href='" . route('systemUpdate.upgrade', ['waiting' => true]) . "'>" . __('here') . '</a>']) . "</p><meta http-equiv=\"refresh\" content=\"5;URL='" . route('systemUpdate.upgrade', ['waiting' => true]) . "'\" />";
        exit;
    }
    set_time_limit(0);
    // Env::set('APP_ENV', 'local');

    Artisan::call('optimize:clear');
    $sourceFile = 'modules_statuses.json';
    $destinationFile = 'modules.json';
    $destinationDirectory = 'Modules';

    // Get the base path and the destination path
    $basePath = base_path($sourceFile);
    $destinationPath = base_path($destinationDirectory . DIRECTORY_SEPARATOR . $destinationFile);

    // Check if the file exists before attempting to move it
    if (\Illuminate\Support\Facades\File::exists($basePath)) {
        // Move the file
        \Illuminate\Support\Facades\File::move($basePath, $destinationPath);
    }
    
    // Add Bulk Payment to modules.json
    $jsonData = json_decode(file_get_contents($destinationPath), true);

    if (!isset($jsonData['Coupon'])) {
        $jsonData['Coupon'] = true;
    }

    if (!isset($jsonData['Ticket'])) {
        $jsonData['Ticket'] = true;
    }

    // Get version once and cache it
    $currentVersion = Env::get('ARTIFISM_VERSION', '1.0.0');

    // Define feature additions with their version requirements
    $featureVersions = [
        'Anthropic' => ['version' => '2.2.0', 'operator' => '<'],
        'PlagiarismCheck' => ['version' => '2.6.0', 'operator' => '<'],
        'Chatbot' => ['version' => '2.7.0', 'operator' => '<'],
        'DeepSeek' => ['version' => '3.4.0', 'operator' => '<='],
        'ElevenLabs' => ['version' => '3.5.0', 'operator' => '<='],
        'Gemini' => ['version' => '3.7.0', 'operator' => '<='],
        'GoogleAdsense' => ['version' => '3.9.0', 'operator' => '<='],
        'FalAi' => ['version' => '4.0.0', 'operator' => '<='],
        'HeyGen' => ['version' => '4.9.0', 'operator' => '<='],
        'AzureOpenAi' => ['version' => '5.0.0', 'operator' => '<='],
        'Pebblely' => ['version' => '5.2.0', 'operator' => '<='],
        'Synthesia' => ['version' => '5.2.0', 'operator' => '<='],
        'Perplexity' => ['version' => '5.3.0', 'operator' => '<='],
        'AiInfluencer' => ['version' => '5.5.0', 'operator' => '<='],
        'Grok' => ['version' => '5.9.0', 'operator' => '<='],
        'Meta' => ['version' => '6.0.0', 'operator' => '<='],
    ];

    // Add features based on version comparison
    foreach ($featureVersions as $feature => $versionInfo) {
        if (version_compare($currentVersion, $versionInfo['version'], $versionInfo['operator'])) {
            $jsonData[$feature] = true;
        }
    }

    // Convert the data back to JSON format
    $newJsonData = json_encode($jsonData, JSON_PRETTY_PRINT);

    try {
        $chatbots = \Modules\OpenAI\Entities\ChatBot::where('code', 'ZXCVB-7')->get();

        if ($chatbots->count() > 1) {
            $firstChatBot = $chatbots->first(); // Keep the first record as it is

            foreach ($chatbots->skip(1) as $index => $chatbot) {
                $chatbot->update(['code' => 'ZXCVB-7-' . ($index + 2)]);
            }
        }
    } catch (\Exception $e) {
        \Log::info($e->getMessage());
    }

    // Write the updated JSON data back to the file
    file_put_contents($destinationPath, $newJsonData);
}


function afterUpgrade(){
    
    Artisan::call('cache:clear');
    Artisan::call('config:cache');
    Artisan::call('config:clear');
    Artisan::call('optimize:clear');

    $directoryPath = storage_path('fonts');

    // Check if the directory already exists
    if (!\Illuminate\Support\Facades\File::exists($directoryPath)) {
        // Create the directory
        \Illuminate\Support\Facades\File::makeDirectory($directoryPath, 0777, true, true);
    }
    // Set permissions (if needed, in case makeDirectory doesn't set it to 777)
    chmod($directoryPath, 0777);

    Artisan::call('module:migrate ' . 'Ticket');
    Artisan::call('module:migrate ' . 'Coupon');
    Artisan::call('module:seed ' . 'Ticket');
    Artisan::call('module:seed ' . 'Coupon');
    Artisan::call('module:seed ' . 'ElevenLabs');
    Artisan::call('module:seed ' . 'Pebblely');
    Artisan::call('module:seed ' . 'AiInfluencer');

    $count = \DB::table('menu_items')->where('link', 'articles')->count();

    if ($count > 1) {
        $firstRecord = \DB::table('menu_items')
        ->where('link', 'articles')
        ->orderBy('id') // Assuming 'id' is the primary key and you want to remove the record with the smallest id
        ->first();

        // Remove the first record
        if ($firstRecord) {
            \DB::table('menu_items')->where('id', $firstRecord->id)->delete(); 
        }
    }

    $menuItems = MenuItems::where('link', 'voiceovers')->orderBy('id')->get();

    if ($menuItems->count() > 1) {
        $menuItems->shift()->delete();
    }

    // Data convertion from old table to new table
    $currentVersion = Env::get('ARTIFISM_VERSION', '1.0.0');

    if (version_compare($currentVersion, '2.3.0', '<')) {
        \DB::beginTransaction();
        try {
            
            $oldChat = \Modules\OpenAI\Entities\Content::get()->toArray();

            $cretivityLevel = 'Medium';
            if (! empty($oldChat)) {
                foreach ($oldChat as $dChat) {
                    if ($dChat['creativity_label'] == '1.00') {
                        $cretivityLevel = 'High';
                    } else if ($dChat['creativity_label'] == '0.50') {
                        $cretivityLevel = 'Optimal';
                    } else if ($dChat['creativity_label'] == '0.80') {
                        $cretivityLevel = 'Low';
                    } else {
                        $cretivityLevel = 'Medium';
                    }
                    // first insertation
                    $chat = new \Modules\OpenAI\Entities\Archive;
                    $chat->title = $dChat['title'];
                    $chat->unique_identifier = (string) \Str::uuid();
                    $chat->provider = 'openai';
                    $chat->type = 'template_chat';
                    $chat->status = 'Active';
                    $chat->created_at = $dChat['created_at'];
                    $chat->updated_at = $dChat['updated_at'];
                    $chat->save();
                    // second insertation
                        
                    $userReply = new \Modules\OpenAI\Entities\Archive;
                    $userReply->parent_id = $chat->id;
                    $userReply->user_id = $dChat['user_id'];
                    $userReply->type = 'template_chat_reply';
                    $userReply->status = 'Active';
                    $userReply->created_at = $dChat['created_at'];
                    $userReply->updated_at = $dChat['updated_at'];
                    $userReply->user_reply = $dChat['promt'];
                    $userReply->save();

                    $botReply = new \Modules\OpenAI\Entities\Archive;
                    $botReply->parent_id = $chat->id;
                    $botReply->provider = 'openai';
                    $botReply->type = 'template';
                    $botReply->content = $dChat['content'];
                    $botReply->provider = 'openai';
                    $botReply->expense = $dChat['tokens'];
                    $botReply->expense_type = 'token';
                    $botReply->type = 'template';
                    $botReply->status = 'Active';
                    $botReply->created_at = $dChat['created_at'];
                    $botReply->updated_at = $dChat['updated_at'];
                    $botReply->template_creator_id = $dChat['user_id'];
                    $botReply->use_case_id = $dChat['use_case_id'];
                    $botReply->template_level = $cretivityLevel;
                    $botReply->template_language = $dChat['language'];
                    $botReply->template_variant = 1;
                    $botReply->template_model = $dChat['model'];
                    $botReply->template_tone = $dChat['tone'];
                    $botReply->template_title = $dChat['title'];
                    $botReply->slug = $dChat['slug'];
                    $botReply->balanceReduce = 'onetime';
                    $botReply->total_words = $dChat['words'];
                    $botReply->save();
                }
            }

            $oldCode = \Modules\OpenAI\Entities\Code::get()->toArray();

            if (! empty($oldCode)) {
                foreach ($oldCode as $dChat) {
                    $code = explode('```', $dChat['code']);
                    // first insertation
                    $chat = new \Modules\OpenAI\Entities\Archive;
                    $chat->title = $dChat['promt'];
                    $chat->unique_identifier = (string) \Str::uuid();
                    $chat->provider = 'openai';
                    $chat->type = 'code';
                    $chat->status = 'Active';
                    $chat->created_at = $dChat['created_at'];
                    $chat->updated_at = $dChat['updated_at'];
                    $chat->save();
                    // second insertation
                        
                    $userReply = new \Modules\OpenAI\Entities\Archive;
                    $userReply->parent_id = $chat->id;
                    $userReply->user_id = $dChat['user_id'];
                    $userReply->type = 'code_chat_reply';
                    $userReply->status = 'Active';
                    $userReply->created_at = $dChat['created_at'];
                    $userReply->updated_at = $dChat['updated_at'];
                    $userReply->user_reply = $dChat['promt'];
                    $userReply->save();

                    $botReply = new \Modules\OpenAI\Entities\Archive;
                    $botReply->parent_id = $chat->id;
                    $botReply->provider = 'openai';
                    $botReply->type = 'code_chat_reply';
                    $botReply->raw_response = $dChat['code'];
                    $botReply->provider = 'openai';
                    $botReply->expense = $dChat['tokens'];
                    $botReply->expense_type = 'token';
                    $botReply->status = 'Active';
                    $botReply->created_at = $dChat['created_at'];
                    $botReply->updated_at = $dChat['updated_at'];
                    $botReply->code_creator_id = $dChat['user_id'];
                    $botReply->code_level = $dChat['code_label'];
                    $botReply->code_language = $dChat['language'];
                    $botReply->code_title = $dChat['promt'];
                    $botReply->formated_code = json_encode($code);
                    $botReply->slug = $dChat['slug'];
                    $botReply->code = $code;
                    $botReply->total_words = $dChat['words'];
                    $botReply->save();
                }
            }
            \DB::commit();

        } catch (\Exception $e) {
            \DB::rollback();
            \Log::info($e->getMessage());
        }
    }

    if (version_compare($currentVersion, '2.7.0', '<')) {
        \DB::beginTransaction();
        try {
            
            $oldChat = \Modules\OpenAI\Entities\Image::get()->toArray();
            $result = [];

            if (! empty($oldChat)) {
                foreach ($oldChat as $item) {
                    // If the 'promt' key already exists in the result array
                    if (isset($result['user_'. $item['user_id']][$item['promt']])) {
                        // Add the item to the nested array for that 'promt'
                        $result['user_'. $item['user_id']][$item['promt']]['children'][] = $item;
                    } else {
                        // Create a new entry, and add the first item as the main element
                        // and prepare a 'children' array to hold any subsequent items
                        $result['user_'. $item['user_id']][$item['promt']] = [
                            'parent' => $item,  // First entry as parent
                            'children' => []    // Initialize empty array for children
                        ];
                    }
                }
            }

            if (! empty($result)) {
                foreach ($result as $dbChat) {
                    foreach ($dbChat as $dChat) {

                        if($dChat['parent']['libraries'] == 'Openai') {
                            $modelData['model'] = 'dall-e-2';
                        } else if($dChat['parent']['libraries'] == 'Stabilityai') {
                            $modelData['model'] = 'stable-diffusion-768-v2-1';
                        } else {
                            $modelData['model'] = null;
                        }
        
                        $modelData['variant'] = '1';
                        $modelData['quality'] = 'standard';
                        $modelData['size'] = $dChat['parent']['size'];
                        $modelData['art_style'] = $dChat['parent']['art_style'];
                        $modelData['light_effect'] = $dChat['parent']['lighting_style'];
                        $modelData['file'] = null;
                        // Convert the associative array to JSON
                        $jsonData = $modelData;
                        // first insertation
                        $chat = new \Modules\OpenAI\Entities\Archive;
                        $chat->user_id = $dChat['parent']['user_id'];
                        $chat->title = $dChat['parent']['promt'];
                        $chat->unique_identifier = (string) \Str::uuid();
                        $chat->type = 'image';
                        $chat->status = 'Active';
                        $chat->created_at = $dChat['parent']['created_at'];
                        $chat->updated_at = $dChat['parent']['updated_at'];
                        $chat->images = json_encode(["public//uploads//aiImages//" . $dChat['parent']['original_name']]);
                        $chat->generation_options = $jsonData;
                        $chat->save();
                        // second insertation
                           
                        $chat1 = new \Modules\OpenAI\Entities\Archive;
                        $chat1->parent_id = $chat->id;
                        $chat1->user_id = $dChat['parent']['user_id'];
                        $chat1->title = $dChat['parent']['promt'];
                        $chat1->unique_identifier = (string) \Str::uuid();
                        $chat1->type = 'image_chat';
                        $chat1->status = 'Active';
                        $chat1->created_at = $dChat['parent']['created_at'];
                        $chat1->user_reply = $dChat['parent']['promt'];
                        $chat1->save();
    
                        // third insertation
                           
                        $chat2 = new \Modules\OpenAI\Entities\Archive;
                        $chat2->parent_id = $chat->id;
                        $chat2->user_id = $dChat['parent']['user_id'];
                        $chat2->title = $dChat['parent']['promt'];
                        $chat2->unique_identifier = (string) \Str::uuid();
                        $chat2->provider = $dChat['parent']['libraries'];
                        $chat2->type = 'image_chat';
                        $chat2->status = 'Active';
                        $chat2->created_at = $dChat['parent']['created_at'];
                        $chat2->images_urls = json_encode(["public//uploads//aiImages/" . $dChat['parent']['original_name']]);
                        $chat2->generation_options = $jsonData;
                        $chat2->save();
    
                        // fourth insertation
                           
                        $chat3 = new \Modules\OpenAI\Entities\Archive;
                        $chat3->parent_id = $chat2->id;
                        $chat3->title = $dChat['parent']['promt'];
                        $chat3->unique_identifier = (string) \Str::uuid();
                        $chat3->type = 'image_variant';
                        $chat3->status = 'Active';
                        $chat3->created_at = $dChat['parent']['created_at'];
                        $chat3->url = "public\\uploads\\aiImages\\".$dChat['parent']['original_name'];
                        $chat3->original_name = $dChat['parent']['original_name'];
                        $chat3->slug = $dChat['parent']['slug'];
                        $chat3->image_creator_id = $dChat['parent']['user_id'];
                        $chat3->generation_options = $jsonData;
                        $chat3->save();
                        // image varient
                        if (!empty($dChat['children'])) {
                            foreach($dChat['children'] as $children) {
                                $chat4 = new \Modules\OpenAI\Entities\Archive;
                                $chat4->parent_id = $chat2->id;
                                $chat4->title = $children['promt'];
                                $chat4->unique_identifier = (string) \Str::uuid();
                                $chat4->type = 'image_variant';
                                $chat4->status = 'Active';
                                $chat4->created_at = $children['created_at'];
                                $chat4->url = "public\\uploads\\aiImages\\".$children['original_name'];
                                $chat4->original_name = $children['original_name'];
                                $chat4->slug = $children['slug'];
                                $chat4->image_creator_id = $children['user_id'];
                                $chat4->generation_options = $jsonData;
                                $chat4->save();
                            }
                        }
                    }
                }
            }
            \DB::commit();
 
        } catch (\Exception $e) {
            \DB::rollback();
            \Log::info($e->getMessage());
        }
    }

    if (version_compare($currentVersion, '3.0.0', '<=')) {
        \DB::beginTransaction();
        try {
            
            $oldChat = \Modules\OpenAI\Entities\Speech::get()->toArray();

            if (! empty($oldChat)) {
                foreach ($oldChat as $dChat) {
                    
                    // First insertion
                    $chat = new \Modules\OpenAI\Entities\Archive;
                    $chat->user_id = $dChat['user_id'];
                    $chat->unique_identifier = (string) \Str::uuid();
                    $chat->provider = 'google';
                    $chat->type = 'speech_to_text_chat';
                    $chat->status = 'Active';
                    $chat->language = $dChat['language'];
                    $chat->file_name = $dChat['file_name'];
                    $chat->temperature = 0;
                    $chat->original_file_name = $dChat['original_file_name'];
                    $chat->updated_at = $dChat['updated_at'];
                    $chat->save();

                    // Second insertion
                    $userReply = new \Modules\OpenAI\Entities\Archive;
                    $userReply->parent_id = $chat->id;
                    $userReply->user_id = $dChat['user_id'];
                    $userReply->provider = 'google';
                    $userReply->type = 'speech_to_text_chat_reply';
                    $userReply->status = 'Active';
                    $userReply->language = $dChat['language'];
                    $userReply->file_name = $dChat['file_name'];
                    $userReply->temperature = 0;
                    $userReply->original_file_name = $dChat['original_file_name'];
                    $userReply->created_at = $dChat['created_at'];
                    $userReply->updated_at = $dChat['updated_at'];
                    $userReply->save();

                    // Third Insertion
                    $botReply = new \Modules\OpenAI\Entities\Archive;
                    $botReply->parent_id = $chat->id;
                    $botReply->title = $dChat['content'];
                    $botReply->content = $dChat['content'];
                    $botReply->provider = 'google';
                    $botReply->type = 'speech_to_text_chat_reply';
                    $botReply->status = 'Active';
                    $botReply->language = $dChat['language'];
                    $botReply->file_name = $dChat['file_name'];
                    $botReply->speech_to_text_creator_id =  $dChat['user_id'];
                    $botReply->temperature = 0;
                    $botReply->original_file_name = $dChat['original_file_name'];
                    $botReply->duration = $dChat['duration']/60;
                    $botReply->created_at = $dChat['created_at'];
                    $botReply->updated_at = $dChat['updated_at'];
                    $botReply->save();
                }
            }
            \DB::commit();

        } catch (\Exception $e) {
            \DB::rollback();
            \Log::info($e->getMessage());
        }
    }

    if (version_compare($currentVersion, '3.1.0', '<=')) {
        \DB::beginTransaction();
        try {
            
            $oldChats = \Modules\OpenAI\Entities\Archive::select(['id', 'provider'])
                ->where('type', 'image_chat')
                ->whereNotNull('provider')
                ->get();
        
            $updateQueries = [];

            foreach ($oldChats as $chat) {
                $updateQueries[] = "WHEN parent_id = {$chat->id} THEN '{$chat->provider}'";
            }
        

            // Build a bulk update query
            if (!empty($updateQueries)) {
                $query = "
                    UPDATE archives
                    SET provider = CASE
                    " . implode(' ', $updateQueries) . "
                    END
                    WHERE parent_id IN (" . $oldChats->pluck('id')->implode(',') . ")
                ";
                
                \DB::statement($query);
            }
            
            \DB::commit();

        } catch (\Exception $e) {
            \DB::rollback();
            \Log::info($e->getMessage());
        }
    }

    if (version_compare($currentVersion, '3.5.0', '<=')) {
        
        \DB::beginTransaction();
        try {
            $audios = \DB::table('audios')->get();

            if (! empty($audios)) {
                foreach ($audios as $audio) {

                    $chat = new \Modules\OpenAI\Entities\Archive;
                    $chat->title = $audio->prompt;
                    $chat->unique_identifier = \Str::uuid();
                    $chat->user_id = $audio->user_id;
                    $chat->provider = 'google';
                    $chat->type = 'voiceover_chat';
                    $chat->save();

                    $generationOptions = [
                        'language' => $audio->language,
                        'volume' => $audio->volume,
                        'gender' => $audio->gender,
                        'pitch' => $audio->pitch,
                        'speed' => $audio->speed,
                        'pause' => $audio->pause,
                        'voice' => $audio->voice,
                        'audio_effect' => $audio->audio_effect,
                    ];

                    $userReply = new \Modules\OpenAI\Entities\Archive;
                    $userReply->parent_id = $chat->id;
                    $userReply->user_id = $audio->user_id;
                    $userReply->type = 'voiceover_chat_reply';
                    $userReply->user_reply = $audio->prompt;
                    $userReply->generation_options = $generationOptions;
                    $userReply->save();
                    
                    $botReply = new \Modules\OpenAI\Entities\Archive;
                    $botReply->parent_id = $chat->id;
                    $botReply->voiceover_creator_id = $chat->user_id;
                    $botReply->title = $audio->prompt;
                    $botReply->provider = 'google';
                    $botReply->type = 'voiceover_chat_reply';
                    $botReply->slug = $audio->slug;
                    $botReply->total_characters = $audio->characters;
                    $botReply->file_name = $audio->file_name;
                    $botReply->generation_options = $generationOptions;
                    $botReply->balanceReduce = 'subscription';
                    $botReply->save();

                    \DB::table('folder_items')->where('item_id', $audio->id)->update(['item_id' => $botReply->id, 'item_type' => 'voiceover_chat_reply']);
                }
                \DB::commit();
            }
        } catch (\Exception $e) {
            \DB::rollback();
            \Log::info($e->getMessage());
        }
    }

    if (version_compare($currentVersion, '3.6.0', '<=')) {

        $menus = MenuItems::where('label', 'Tools')->get();

        if ($menus->count() > 1) {
            $menus->skip(1)->each->delete();
        }

        $menu = $menus->first();

        if ($menu) {
            $menu->update(['sort' => 50, 'icon' => 'fas fa-cogs']);
            $id = $menu->id;

            // Update parent only if the items exist
            MenuItems::whereIn('link', ['import/actors', 'manual-backup-list'])->get()->each(function ($item) use ($id) {
                $item->update(['parent' => $id]);
            });
        }
    }

    if (version_compare($currentVersion, '3.7.0', '<=')) {
        \App\Models\User::where('email', 'user@techvill.net')->skip(1)->delete();
    }

    if (version_compare($currentVersion, '4.6.0', '<=')) {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        \DB::statement('DROP TABLE IF EXISTS contents');
        \DB::statement('DROP TABLE IF EXISTS content_meta');
        \DB::statement('DROP TABLE IF EXISTS codes');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }

    if (version_compare($currentVersion, '4.7.0', '<=')) {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        \DB::statement('DROP TABLE IF EXISTS speeches');
        \DB::statement('DROP TABLE IF EXISTS audios');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }

    if (version_compare($currentVersion, '4.9.0', '<=')) {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        \DB::statement('DROP TABLE IF EXISTS images');
        \DB::statement('DROP TABLE IF EXISTS chats');
        \DB::statement('DROP TABLE IF EXISTS chat_conversations');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }

    if (version_compare($currentVersion, '5.0.0', '<=')) {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        \DB::statement('DROP TABLE IF EXISTS content_types');
        \DB::statement('DROP TABLE IF EXISTS content_types_meta');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
        
        MenuItems::where('label', 'AI Voices')->delete();
    }

    if (version_compare($currentVersion, '6.1.0', '<=') && Env::get('QUEUE_CONNECTION') != 'database') {
        Env::set('QUEUE_CONNECTION', 'database');
    }
}
